/*******************************************************************************
This code replicates Figure 12: International Transmission of FED Hikes: Emerging
vs Advanced Economies with Global Controls (GK surprises) 

For confidentiality issues, we are not providing UIP data, that's why we comment 
that part of the code.

*******************************************************************************/

clear
set more off
cls
clear matrix
clear mata 
set maxvar 8000
//set graphics off
cap cd "Replication_pkg/Data_programs"  
cap n log close _all

use "LP_data", clear

*****************
//Drop covid 
******************
drop if time_q>tq(2019q4) 

/*******************************************************************************
Check units
*******************************************************************************/
replace i_treasury_12m_avg_US=i_treasury_12m_avg_US/100

/*******************************************************************************
Generate groups
*******************************************************************************/
//Updated ER classification
drop if IRR_coarse==1
drop if IRR_coarse==6

/*******************************************************************************
Global factors 
*******************************************************************************/
//Global dollar shock as in 0Z (2022): 10% size shock 
xtset IFS_code time_q 
g Dollar_shock=ln(aeusd_g)-ln(l.aeusd_g)
replace Dollar_shock=Dollar_shock/0.1 

//Trade balance:
bys time_q EM: egen median_tb=median(trade_balance_GDP)

//Commodity index 
g l_oil=ln(oil_index)

/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"

/*******************************************************************************
Set parameters of LP
*******************************************************************************/
global lags=4 
global horizon=10 
global conf=90 //confidence levels 
global cinorm = invnormal($conf/100)
global instrument "ff4"


/*
Get RHS:
1. Lags of dependent variable 
2. Lags of gdp growth and inflation differentials 
3. Lags of the shockvar 
4. Lags of the instrument
*/
xtset IFS_code time_q 
g lcpi=ln(cpi_IFS)
g inflationIFS=D.lcpi //inflation q to q 

//winsor inflation:
winsor2 inflationIFS, replace cuts(4 96)

g ler=ln(ER_avg_IFS) 
g g_er=D.ler //ER q to q
g lgdp=ln(rGDPsa_weo)


foreach var of varlist g_gdp_final inflationIFS {
	g double var1=`var' if IFS_code==111
	bys time_q: egen double max=max(var1) 
	g double `var'_diff=`var'-max 
	drop var1 max 
	}

xtset IFS_code time_q 
//Lags 
foreach var of varlist lgdp inflationIFS g_gdp_final_diff inflationIFS_diff i_treasury_12m_avg_US g_er all_DB_inflow_AHKS_GDP_2023 i_policy_US  $instrument trade_balance_GDP Dollar_shock median_tb  l_oil /*ln_theta_12m_treasury*/{ 
	forv l=1/$lags { 
		g `var'_l`l'=l`l'.`var'

	}
}
/*
Get the LHS: 
*/	
//Leads 
foreach var of varlist lgdp inflationIFS g_er all_DB_inflow_AHKS_GDP_2023 i_policy_US /*ln_theta_12m_treasury*/{ 
	forv h=0/$horizon{ 
		g `var'_`h'=f`h'.`var'
		
	}	
}

// Time span: 
keep if time_q>=tq(1990q1) 

/*******************************************************************************
LP IV regression
*******************************************************************************/
cd "../../Replication_pkg/Figures/Figure 12"
global x="*g_gdp_final_diff_l* *inflationIFS_diff_l* *i_treasury_12m_avg_US_l* ${instrument}_l* *Dollar_shock* *median_tb* *l_oil*"

global colorHigh "red" 
global colorLow "blue"

/*
Obtain coefficient to normalize 
*/

//drop USA
drop if IFS_code==111

ivreghdfe i_policy_US_0 i_policy_US_l1-i_policy_US_l4 "$x" (i_treasury_12m_avg_US=${instrument}), absorb(IFS_code) 
global b_norm=_b[i_treasury_12m_avg_US]

/*
GDP levels
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1

	//EM 
	ivreghdfe lgdp_`h' *lgdp_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	//AE 
	ivreghdfe lgdp_`h' *lgdp_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==0, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coefAE[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coefAE[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:EM}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(lgdp_EM,replace)
graph save "lgdpEM.gph", replace

cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:AE}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(lgdp_AE,replace)
graph save "lgdpAE.gph", replace
graph combine "lgdpEM.gph" "lgdpAE.gph", cols(2) title("{bf:GDP}", size(vlarge)) name(gdp,replace) ycom
rm "lgdpEM.gph"
rm "lgdpAE.gph"
graph export "lGDP.pdf", replace
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 12.xlsx", sheet("GDP", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb

/*
/*
12m UIP deviation in treasury 
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	
	//EM 
	ivreghdfe ln_theta_12m_treasury_`h' *ln_theta_12m_treasury_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	//AE 
	ivreghdfe ln_theta_12m_treasury_`h' *ln_theta_12m_treasury_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==0, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coefAE[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coefAE[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:EM}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(uip_EM,replace)
graph save "uipEM.gph", replace 
cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:AE}", size(huge)) xlabel(1(2)10,nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(uip_AE,replace)
graph save "uipAE.gph", replace 

graph combine "uipEM.gph" "uipAE.gph", title("{bf:12m UIP deviation}", size(vlarge)) name(UIP,replace) ycom
graph export "UIP.pdf", replace
rm "uipEM.gph"
rm "uipAE.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 12.xlsx", sheet("UIP", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb
*/

/*
Exchange rate q/q growth
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	//EM 
	ivreghdfe g_er_`h' *g_er_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	//AE 
	ivreghdfe g_er_`h' *g_er_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==0, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coefAE[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coefAE[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:EM}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(g_er_EM,replace)
graph save "g_er_EM.gph", replace 
cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:AE}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(g_er_AE,replace)
graph save "g_er_AE.gph", replace 
graph combine "g_er_EM.gph" "g_er_AE", title("{bf:Exchange Rate (Local/USD)}", size(vlarge)) name(g_er, replace) ycom
graph export "g_er.pdf", replace
rm "g_er_EM.gph"
rm "g_er_AE.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 12.xlsx", sheet("ER", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb


/*
Capital flows to GDP
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	//EM 
	ivreghdfe all_DB_inflow_AHKS_GDP_2023_`h' *all_DB_inflow_AHKS_GDP_2023_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==1, absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coef[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coef[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	//AE 
	ivreghdfe all_DB_inflow_AHKS_GDP_2023_`h' *all_DB_inflow_AHKS_GDP_2023_l* $x ///
	(i_treasury_12m_avg_US=${instrument}) if EM==0 , absorb(IFS_code) first bw(`neweylag') level(90)
	
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=_b[i_treasury_12m_avg_US]/${b_norm}
	mat coefAE[`j',4]=(_b[i_treasury_12m_avg_US]+${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	mat coefAE[`j',5]=(_b[i_treasury_12m_avg_US]-${cinorm}*_se[i_treasury_12m_avg_US])/${b_norm} 
	
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:EM}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(inflow_EM,replace)
graph save "capflowsEM.gph", replace
cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:AE}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(inflow_AE,replace)
graph save "capflowsAE.gph", replace

graph combine "capflowsEM" "capflowsAE", title( "{bf:Capital Inflows to GDP}", size(vlarge)) name(capflows, replace) ycom
graph export "flows.pdf", replace
rm "capflowsEM.gph"
rm "capflowsAE.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 12.xlsx", sheet("Capflows", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb



